/**
 * File skip-link-focus-fix.js.
 *
 * Helps with accessibility for keyboard only users.
 *
 * This is the source file for what is minified in the newspack_skip_link_focus_fix() PHP function.
 *
 * Learn more: https://git.io/vWdr2
 */
( function () {
	const isIe = /(trident|msie)/i.test( navigator.userAgent );

	if ( isIe && document.getElementById && window.addEventListener ) {
		window.addEventListener(
			'hashchange',
			function () {
				const id = location.hash.substring( 1 );

				if ( ! /^[A-z0-9_-]+$/.test( id ) ) {
					return;
				}

				const element = document.getElementById( id );

				if ( element ) {
					if ( ! /^(?:a|select|input|button|textarea)$/i.test( element.tagName ) ) {
						element.tabIndex = -1;
					}

					element.focus();
				}
			},
			false
		);
	}
} )();
